/*
 * Decompiled with CFR 0.152.
 */
package uk.co.cablepost.autoworkstations.auto_enchanting_table;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2331;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7924;
import net.minecraft.class_9636;
import org.jetbrains.annotations.Nullable;
import uk.co.cablepost.autoworkstations.auto_enchanting_table.AutoEnchantingTableScreenHandler;
import uk.co.cablepost.autoworkstations.util.TextUtil;

public class AutoEnchantingTableBlockEntity
extends class_2586
implements class_1278,
class_3908 {
    public static int INVENTORY_SIZE = 5;
    protected class_2371<class_1799> inventory = class_2371.method_10213((int)INVENTORY_SIZE, (Object)class_1799.field_8037);
    public static int SLOT_EXP_BOTTLE = 0;
    public static int SLOT_EMPTY_BOTTLE = 1;
    public static int SLOT_ITEM_TO_ENCHANT = 2;
    public static int SLOT_LAPIS = 3;
    public static int SLOT_ENCHANTED_ITEM = 4;
    public int enchantSeed;
    public class_6575 random;
    int xpEmptyBottleProgress;
    public int xpEmptyBottleMaxProgress = 20;
    int expLevel;
    float expProgress;
    public int[] enchantPowers = new int[3];
    public int selectedEnchantTier = 3;
    private boolean canDoEnchantPowers = false;
    private boolean canDoEnchantRequirements = false;
    public class_1799 lastToEnchantItemStack = null;
    public int enchantProgress;
    public int maxEnchantProgress = 60;
    public int bookshelfCount = -1;
    public float targetBookRotation;
    public float bookRotation;
    public float lastBookRotation;
    public static int PROPERTY_DELEGATE_SIZE = 7;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            switch (index) {
                case 0: {
                    return Math.round(AutoEnchantingTableBlockEntity.this.expProgress * 100.0f);
                }
                case 1: {
                    return AutoEnchantingTableBlockEntity.this.expLevel;
                }
                case 2: {
                    return AutoEnchantingTableBlockEntity.this.xpEmptyBottleProgress;
                }
                case 3: {
                    return AutoEnchantingTableBlockEntity.this.xpEmptyBottleMaxProgress;
                }
                case 4: {
                    return AutoEnchantingTableBlockEntity.this.enchantProgress;
                }
                case 5: {
                    return AutoEnchantingTableBlockEntity.this.maxEnchantProgress;
                }
                case 6: {
                    return AutoEnchantingTableBlockEntity.this.selectedEnchantTier;
                }
            }
            return 0;
        }

        public void method_17391(int index, int value) {
        }

        public int method_17389() {
            return PROPERTY_DELEGATE_SIZE;
        }
    };

    public AutoEnchantingTableBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.enchantSeed = AutoEnchantingTableBlockEntity.generateEnchantSeed();
        this.random = new class_6575((long)this.enchantSeed);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 wrapperLookup) {
        super.method_11014(nbt, wrapperLookup);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)wrapperLookup);
        this.enchantSeed = nbt.method_10550("EnchantSeed");
        this.xpEmptyBottleProgress = nbt.method_10550("XpEmptyBottleProgress");
        this.xpEmptyBottleMaxProgress = nbt.method_10550("XpEmptyBottleMaxProgress");
        if (this.xpEmptyBottleMaxProgress == 0) {
            this.xpEmptyBottleMaxProgress = 20;
        }
        this.expLevel = nbt.method_10550("ExpLevel");
        this.expProgress = nbt.method_10583("ExpProgress");
        this.enchantPowers = nbt.method_10561("EnchantPowers");
        this.selectedEnchantTier = nbt.method_10550("SelectedEnchantTier");
        this.canDoEnchantPowers = nbt.method_10577("CanDoEnchantPowers");
        this.canDoEnchantRequirements = nbt.method_10577("CanDoEnchantRequirements");
        this.enchantProgress = nbt.method_10550("EnchantProgress");
        this.maxEnchantProgress = nbt.method_10550("MaxEnchantProgress");
        if (this.maxEnchantProgress == 0) {
            this.maxEnchantProgress = 60;
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 wrapperLookup) {
        super.method_11007(nbt, wrapperLookup);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)wrapperLookup);
        nbt.method_10569("EnchantSeed", this.enchantSeed);
        nbt.method_10569("XpEmptyBottleProgress", this.xpEmptyBottleProgress);
        nbt.method_10569("XpEmptyBottleMaxProgress", this.xpEmptyBottleMaxProgress);
        nbt.method_10569("ExpLevel", this.expLevel);
        nbt.method_10548("ExpProgress", this.expProgress);
        nbt.method_10539("EnchantPowers", this.enchantPowers);
        nbt.method_10569("SelectedEnchantTier", this.selectedEnchantTier);
        nbt.method_10556("CanDoEnchantPowers", this.canDoEnchantPowers);
        nbt.method_10556("CanDoEnchantRequirements", this.canDoEnchantRequirements);
        nbt.method_10569("EnchantProgress", this.enchantProgress);
        nbt.method_10569("MaxEnchantProgress", this.maxEnchantProgress);
    }

    public static int generateEnchantSeed() {
        return new Random().nextInt();
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, AutoEnchantingTableBlockEntity blockEntity) {
        float g;
        blockEntity.lastBookRotation = blockEntity.bookRotation;
        class_1657 playerEntity = world.method_18459((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 3.0, false);
        if (playerEntity != null) {
            double d = playerEntity.method_23317() - ((double)pos.method_10263() + 0.5);
            double e = playerEntity.method_23321() - ((double)pos.method_10260() + 0.5);
            blockEntity.targetBookRotation = (float)class_3532.method_15349((double)e, (double)d);
        } else {
            blockEntity.targetBookRotation += 0.02f;
        }
        while (blockEntity.bookRotation >= (float)Math.PI) {
            blockEntity.bookRotation -= (float)Math.PI * 2;
        }
        while (blockEntity.bookRotation < (float)(-Math.PI)) {
            blockEntity.bookRotation += (float)Math.PI * 2;
        }
        while (blockEntity.targetBookRotation >= (float)Math.PI) {
            blockEntity.targetBookRotation -= (float)Math.PI * 2;
        }
        while (blockEntity.targetBookRotation < (float)(-Math.PI)) {
            blockEntity.targetBookRotation += (float)Math.PI * 2;
        }
        for (g = blockEntity.targetBookRotation - blockEntity.bookRotation; g >= (float)Math.PI; g -= (float)Math.PI * 2) {
        }
        while (g < (float)(-Math.PI)) {
            g += (float)Math.PI * 2;
        }
        blockEntity.bookRotation += g * 0.4f;
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, AutoEnchantingTableBlockEntity blockEntity) {
        boolean toMarkDirty = false;
        class_1799 expBottlesStack = (class_1799)blockEntity.inventory.get(SLOT_EXP_BOTTLE);
        class_1799 emptyBottlesStack = (class_1799)blockEntity.inventory.get(SLOT_EMPTY_BOTTLE);
        if (!expBottlesStack.method_7960() && expBottlesStack.method_31574(class_1802.field_8287) && (emptyBottlesStack.method_7960() || emptyBottlesStack.method_31574(class_1802.field_8469) && emptyBottlesStack.method_7947() < emptyBottlesStack.method_7914())) {
            ++blockEntity.xpEmptyBottleProgress;
            if (blockEntity.xpEmptyBottleProgress >= blockEntity.xpEmptyBottleMaxProgress) {
                blockEntity.addExperience(Math.round(8.0f));
                expBottlesStack.method_7934(1);
                if (emptyBottlesStack.method_7960()) {
                    emptyBottlesStack = new class_1799((class_1935)class_1802.field_8469);
                } else {
                    emptyBottlesStack.method_7933(1);
                }
                blockEntity.inventory.set(SLOT_EMPTY_BOTTLE, (Object)emptyBottlesStack);
                blockEntity.xpEmptyBottleProgress = 0;
                toMarkDirty = true;
            }
        } else {
            blockEntity.xpEmptyBottleProgress = 0;
        }
        class_1799 toEnchant = blockEntity.method_5438(SLOT_ITEM_TO_ENCHANT);
        boolean bookshelfCountChanged = blockEntity.updateBookshelfCount();
        if (blockEntity.lastToEnchantItemStack == null || blockEntity.lastToEnchantItemStack.method_7960() != toEnchant.method_7960() || blockEntity.lastToEnchantItemStack.method_7909() != toEnchant.method_7909() || blockEntity.lastToEnchantItemStack.method_7947() != toEnchant.method_7947() || bookshelfCountChanged) {
            blockEntity.lastToEnchantItemStack = blockEntity.method_5438(SLOT_ITEM_TO_ENCHANT).method_7972();
            class_1799 singularItemToEnchant = toEnchant.method_7972();
            singularItemToEnchant.method_7939(1);
            if (!toEnchant.method_7960() && singularItemToEnchant.method_7923()) {
                for (int i = 0; i < 10; ++i) {
                    blockEntity.canDoEnchantPowers = blockEntity.updateEnchantPowers();
                    if (blockEntity.enchantPowers[blockEntity.selectedEnchantTier - 1] <= 0) {
                        continue;
                    }
                    break;
                }
            } else {
                blockEntity.canDoEnchantPowers = false;
            }
        }
        if (world.method_8510() % 20L == 0L && !toEnchant.method_7960()) {
            class_1799 toEnchantSingle = toEnchant.method_7972();
            toEnchantSingle.method_7939(1);
            if (!toEnchantSingle.method_7923()) {
                world.method_8396(null, pos, (class_3414)class_3417.field_18310.comp_349(), class_3419.field_15245, 0.5f, 1.0f);
            }
        }
        blockEntity.canDoEnchantRequirements = blockEntity.canDoEnchantPowers ? blockEntity.canDoEnchant() : false;
        if (blockEntity.canDoEnchantPowers && blockEntity.canDoEnchantRequirements) {
            ++blockEntity.enchantProgress;
            if (blockEntity.enchantProgress >= blockEntity.maxEnchantProgress) {
                blockEntity.doEnchant();
                blockEntity.enchantProgress = 0;
                blockEntity.lastToEnchantItemStack = null;
            }
        }
        if (!blockEntity.canDoEnchantPowers || !blockEntity.canDoEnchantRequirements) {
            blockEntity.enchantProgress = 0;
        }
        if (toMarkDirty) {
            blockEntity.method_5431();
        }
    }

    public int getBookshelfCount() {
        int i = 0;
        for (class_2338 blockPos : class_2331.field_36535) {
            if (!class_2331.method_40445((class_1937)this.field_11863, (class_2338)this.field_11867, (class_2338)blockPos)) continue;
            ++i;
        }
        return i;
    }

    public boolean updateBookshelfCount() {
        int newBookshelfCount = this.getBookshelfCount();
        if (this.bookshelfCount != newBookshelfCount) {
            this.bookshelfCount = newBookshelfCount;
            return true;
        }
        return false;
    }

    public boolean updateEnchantPowers() {
        class_1799 toEnchant = this.method_5438(SLOT_ITEM_TO_ENCHANT);
        class_1799 singularItemToEnchant = toEnchant.method_7972();
        singularItemToEnchant.method_7939(1);
        if (toEnchant.method_7960() || !singularItemToEnchant.method_7923()) {
            this.enchantPowers = new int[]{0, 0, 0};
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            this.enchantPowers[i] = class_1890.method_8227((class_5819)this.random, (int)i, (int)this.bookshelfCount, (class_1799)singularItemToEnchant);
            if (this.enchantPowers[i] >= i + 1) continue;
            this.enchantPowers[i] = 0;
        }
        return this.enchantPowers[this.selectedEnchantTier - 1] > 0;
    }

    public boolean canDoEnchant() {
        if (this.expLevel < this.enchantPowers[this.selectedEnchantTier - 1]) {
            return false;
        }
        class_1799 lapis = this.method_5438(SLOT_LAPIS);
        if (lapis.method_7960() || lapis.method_7947() < this.selectedEnchantTier) {
            return false;
        }
        class_1799 outputSlot = this.method_5438(SLOT_ENCHANTED_ITEM);
        return outputSlot.method_7960();
    }

    public void doEnchant() {
        List<class_1889> enchants;
        class_1799 lapis = this.method_5438(SLOT_LAPIS);
        class_1799 itemEnchanting = this.method_5438(SLOT_ITEM_TO_ENCHANT).method_7972();
        itemEnchanting.method_7939(1);
        this.method_5438(SLOT_ITEM_TO_ENCHANT).method_7934(1);
        if (this.method_5438(SLOT_ITEM_TO_ENCHANT).method_7960()) {
            this.method_5447(SLOT_ITEM_TO_ENCHANT, class_1799.field_8037);
        }
        if ((enchants = this.generateEnchantments(this.field_11863.method_45162(), itemEnchanting, this.enchantPowers[this.selectedEnchantTier - 1])) != null && !enchants.isEmpty()) {
            boolean isBook;
            this.addExperienceLevels(-this.selectedEnchantTier);
            lapis.method_7934(this.selectedEnchantTier);
            if (lapis.method_7960()) {
                this.method_5447(SLOT_LAPIS, class_1799.field_8037);
            }
            if (isBook = itemEnchanting.method_31574(class_1802.field_8529)) {
                itemEnchanting = itemEnchanting.method_56701((class_1935)class_1802.field_8598, 1);
            }
            for (class_1889 enchantmentLevelEntry : enchants) {
                itemEnchanting.method_7978(enchantmentLevelEntry.field_9093, enchantmentLevelEntry.field_9094);
            }
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_15119, class_3419.field_15245, 0.3f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
        } else {
            this.field_11863.method_8396(null, this.field_11867, (class_3414)class_3417.field_18310.comp_349(), class_3419.field_15245, 0.3f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
        }
        this.method_5447(SLOT_ENCHANTED_ITEM, itemEnchanting);
    }

    private List<class_1889> generateEnchantments(class_7699 enabledFeatures, class_1799 stack, int level) {
        Optional optional = this.field_11863.method_30349().method_30530(class_7924.field_41265).method_40266(class_9636.field_51547);
        List list = class_1890.method_8230((class_5819)this.random, (class_1799)stack, (int)level, (Stream)((class_6885.class_6888)optional.get()).method_40239());
        if (stack.method_31574(class_1802.field_8529) && list.size() > 1) {
            list.remove(this.random.method_43048(list.size()));
        }
        return list;
    }

    public void addExperience(int experience) {
        this.expProgress += (float)experience / (float)this.getNextLevelExperience();
        while (this.expProgress < 0.0f) {
            float f = this.expProgress * (float)this.getNextLevelExperience();
            if (this.expLevel > 0) {
                this.addExperienceLevels(-1);
                this.expProgress = 1.0f + f / (float)this.getNextLevelExperience();
                continue;
            }
            this.addExperienceLevels(-1);
            this.expProgress = 0.0f;
        }
        while (this.expProgress >= 1.0f) {
            this.expProgress = (this.expProgress - 1.0f) * (float)this.getNextLevelExperience();
            this.addExperienceLevels(1);
            this.expProgress /= (float)this.getNextLevelExperience();
        }
    }

    public void addExperienceLevels(int levels) {
        this.expLevel += levels;
        if (this.expLevel < 0) {
            this.expLevel = 0;
            this.expProgress = 0.0f;
        }
    }

    public int getNextLevelExperience() {
        if (this.expLevel >= 30) {
            return 112 + (this.expLevel - 30) * 9;
        }
        if (this.expLevel >= 15) {
            return 37 + (this.expLevel - 15) * 5;
        }
        return 7 + this.expLevel * 2;
    }

    public class_2561 method_5476() {
        return TextUtil.translatableText(this.method_11010().method_26204().method_9539());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new AutoEnchantingTableScreenHandler(syncId, inv, (class_1263)this, this.propertyDelegate);
    }

    public int[] method_5494(class_2350 side) {
        int[] result = new int[this.inventory.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i;
        }
        return result;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (dir == class_2350.field_11036 || dir == class_2350.field_11033) {
            return slot == SLOT_ITEM_TO_ENCHANT;
        }
        if (slot == SLOT_EXP_BOTTLE) {
            return stack.method_31574(class_1802.field_8287);
        }
        if (slot == SLOT_LAPIS) {
            return stack.method_31574(class_1802.field_8759);
        }
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == SLOT_EMPTY_BOTTLE || slot == SLOT_ENCHANTED_ITEM;
    }

    public int method_5439() {
        return this.inventory.size();
    }

    public boolean method_5442() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (((class_1799)this.inventory.get(i)).method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.inventory.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        if (amount == 0) {
            return class_1799.field_8037;
        }
        if (amount == ((class_1799)this.inventory.get(slot)).method_7947()) {
            return this.method_5441(slot);
        }
        class_1799 toRet = ((class_1799)this.inventory.get(slot)).method_7972();
        ((class_1799)this.inventory.get(slot)).method_7934(amount);
        toRet.method_7939(amount);
        return toRet;
    }

    public class_1799 method_5441(int slot) {
        class_1799 toRet = ((class_1799)this.inventory.get(slot)).method_7972();
        this.inventory.set(slot, (Object)class_1799.field_8037);
        return toRet;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public void method_5431() {
        boolean serverSide = this.method_11002() && !this.method_10997().method_8608();
        super.method_5431();
        if (serverSide) {
            ((class_3218)this.field_11863).method_14178().method_14128(this.method_11016());
        }
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 wrapperLookup) {
        return this.method_38244(wrapperLookup);
    }

    public void dropXP() {
        int amt = this.expLevel * 7;
        amt = Math.min(amt, 100);
        class_1303.method_31493((class_3218)((class_3218)this.field_11863), (class_243)class_243.method_24953((class_2382)this.field_11867), (int)amt);
    }
}

